// ============================================================
// Welcome Script - VYROX POS Printer Connector
// ============================================================

var extId = chrome.runtime.id;
document.getElementById("ext-id").textContent = extId;

document.getElementById("copy-btn").addEventListener("click", function () {
  navigator.clipboard.writeText(extId).then(function () {
    var btn = document.getElementById("copy-btn");
    btn.textContent = "Copied!";
    btn.classList.add("copied");
    setTimeout(function () {
      btn.textContent = "Copy";
      btn.classList.remove("copied");
    }, 2000);
  });
});

// Write extension ID to download.txt so the installer can read it
function writeExtensionIdFile() {
  var dataUrl = "data:text/plain;charset=utf-8," + encodeURIComponent(extId);

  chrome.downloads.download(
    {
      url: dataUrl,
      filename: "VYROX_ExtensionID.txt",
      saveAs: false,
      conflictAction: "overwrite"
    },
    function () {
      if (chrome.runtime.lastError) {
        console.log("Failed to write extension ID file: " + chrome.runtime.lastError.message);
      }
    }
  );
}

// Auto-download the native host installer on first install
function autoDownloadInstaller() {
  var downloadUrl = "https://vyrox.com/miniapps/VYROX_POSPrinterConnector/VYROX_POSPrinterConnector.exe";

  chrome.storage.local.get("installerDownloaded", function (data) {
    if (data.installerDownloaded) return;

    chrome.downloads.download(
      {
        url: downloadUrl,
        filename: "VYROX_POSPrinterConnector.exe",
        saveAs: false
      },
      function (downloadId) {
        if (chrome.runtime.lastError) {
          console.log("Auto-download failed: " + chrome.runtime.lastError.message);
          return;
        }
        if (downloadId) {
          chrome.storage.local.set({ installerDownloaded: true });
        }
      }
    );
  });
}

writeExtensionIdFile();
autoDownloadInstaller();