// ============================================================
// Popup Script - VYROX POS Printer Connector
// ============================================================

var hostStatusEl = document.getElementById("host-status");
var printerStatusEl = document.getElementById("printer-status");
var lastPrintEl = document.getElementById("last-print");
var logEl = document.getElementById("log");

function log(message, type) {
  var entry = document.createElement("div");
  entry.className = "log-entry log-" + (type || "info");
  entry.textContent = new Date().toLocaleTimeString() + " " + message;
  logEl.prepend(entry);
}

function setHostStatus(ok, text) {
  var dotClass = ok ? "dot-ok" : "dot-err";
  var textClass = ok ? "status-ok" : "status-err";
  hostStatusEl.innerHTML =
    '<span class="dot ' + dotClass + '"></span>' +
    '<span class="' + textClass + '">' + text + "</span>";
}

function setPrinterStatus(ok, text) {
  var dotClass = ok ? "dot-ok" : "dot-err";
  var textClass = ok ? "status-ok" : "status-err";
  var cleanText = text.replace(/[^\x20-\x7E]/g, '').trim();
  cleanText = cleanText.replace(/^Printer\s+/i, '');
  if (!cleanText) cleanText = text.trim();
  printerStatusEl.innerHTML =
    '<span class="dot ' + dotClass + '"></span>' +
    '<span class="' + textClass + '">' + cleanText + "</span>";
}

function showInstallPrompt() {
  var installPrompt = document.getElementById("install-prompt");
  var infoNormal = document.getElementById("info-normal");
  if (installPrompt) installPrompt.style.display = "block";
  if (infoNormal) infoNormal.style.display = "none";
}

// Test connection on popup open
chrome.runtime.sendMessage({ action: "testConnection" }, function (response) {
  if (chrome.runtime.lastError) {
    setHostStatus(false, "Not installed");
    setPrinterStatus(false, "Unavailable");
    log("Native host not found: " + chrome.runtime.lastError.message, "err");
    showInstallPrompt();
    return;
  }

  if (response && response.success) {
    setHostStatus(true, "Connected");
    log("Native host connected", "ok");

    if (response.response && response.response.printer) {
      var printerName = response.response.printer;
      printerName = printerName.replace(/^Printer\s+/i, '');
      setPrinterStatus(true, printerName);
      log("Printer: " + printerName, "ok");
    } else {
      setPrinterStatus(true, "Ready");
    }

  } else {
    setHostStatus(false, "Error");
    setPrinterStatus(false, "Unknown");
    log(
      "Connection failed: " + (response ? response.error : "No response"),
      "err"
    );
    showInstallPrompt();
  }
});

// Load last print time
chrome.storage.local.get("lastPrint", function (data) {
  if (data.lastPrint) {
    lastPrintEl.textContent = data.lastPrint;
  }
});

// Test button
document.getElementById("btn-test").addEventListener("click", function () {
  log("Testing connection...", "info");
  chrome.runtime.sendMessage(
    { action: "testConnection" },
    function (response) {
      if (response && response.success) {
        setHostStatus(true, "Connected");
        log("Test OK", "ok");
      } else {
        setHostStatus(false, "Failed");
        log("Test failed", "err");
      }
    }
  );
});

// Print button
document.getElementById("btn-print").addEventListener("click", function () {
  chrome.tabs.query(
    { active: true, currentWindow: true },
    function (tabs) {
      if (!tabs[0]) return;

      chrome.tabs.sendMessage(
        tabs[0].id,
        { action: "triggerPrint" },
        function (response) {
          if (chrome.runtime.lastError) {
            log("Could not reach content script", "err");
            return;
          }
          if (response && response.success) {
            var now = new Date().toLocaleTimeString();
            lastPrintEl.textContent = now;
            chrome.storage.local.set({ lastPrint: now });
            log("Print sent", "ok");
          } else {
            log(
              "Print failed: " +
                (response ? response.error : "Unknown"),
              "err"
            );
          }
        }
      );
    }
  );
});

// Log toggle
document.getElementById("btn-log").addEventListener("click", function () {
  logEl.classList.toggle("visible");
});